﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>
#include <nn/TargetConfigs/build_Base.h>

//#define NN_VI_ENABLE_MEMORY_DUMP

#define NN_VI_LOG(...)      NN_SDK_LOG("[vi]" __VA_ARGS__)
#define NN_VI_LOG_WARN(...) NN_SDK_LOG("[vi][warn]" __VA_ARGS__)
#define NN_VI_LOG_ERR(...)  NN_SDK_LOG("[vi][err]" __VA_ARGS__)


//#define NN_VI_LOG_DEV(...) NN_VI_LOG("[dev]" __VA_ARGS__)


#define NN_VI_WARN(...) NN_SDK_LOG("[vi] " __VA_ARGS__)
#ifdef NN_BUILD_CONFIG_TOOLCHAIN_VC
    #define NN_VI_DEPRECATED NN_VI_WARN("%s is deprecated and will be removed in a future SDK.  Please check the documentation for details.\n", __FUNCTION__)
#else
    #define NN_VI_DEPRECATED NN_VI_WARN("%s is deprecated and will be removed in a future SDK.  Please check the documentation for details.\n", __func__)
#endif

// info log
//#define NN_VI_LOG_MEM(...)      NN_VI_LOG("[mem]" __VA_ARGS__)
//#define NN_VI_LOG_LIFETIME(...) NN_VI_LOG("[lifetime]" __VA_ARGS__)


// empty definitions
#ifndef NN_VI_LOG
#define NN_VI_LOG(...)
#endif
#ifndef NN_VI_LOG_WARN
#define NN_VI_LOG_WARN(...)
#endif
#ifndef NN_VI_LOG_ERR
#define NN_VI_LOG_ERR(...)
#endif

#ifndef NN_VI_LOG_DEV
#define NN_VI_LOG_DEV(...)
#endif

#ifndef NN_VI_LOG_MEM
#define NN_VI_LOG_MEM(...)
#endif
#ifndef NN_VI_LOG_LIFETIME
#define NN_VI_LOG_LIFETIME(...)
#endif
