﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include "vi_Log.h"
#include "native/vi_NativeWindowHolder.h"

namespace nn{ namespace vi{
    class DisplayHolder;

    class LayerHolder
        : public nn::util::IntrusiveListBaseNode<LayerHolder>
    {
        NN_DISALLOW_COPY(LayerHolder);
    public:

        LayerHolder(LayerId id, DisplayHolder* pDisplayHolder) NN_NOEXCEPT
            : m_Id(id)
            , m_pDisplayHolder(pDisplayHolder)
        {
            NN_VI_LOG_LIFETIME("LayerHolder ctor\n");
        }

        ~LayerHolder() NN_NOEXCEPT
        {
            NN_VI_LOG_LIFETIME("LayerHolder dtor\n");
            m_Id = 0;
            m_pDisplayHolder = nullptr;

            m_NativeWindowHolder.Reset();
        }

        LayerId GetId() const NN_NOEXCEPT
        {
            return m_Id;
        }

        DisplayHolder* GetDisplayHolder() NN_NOEXCEPT
        {
            return m_pDisplayHolder;
        }

        ANativeWindow* GetNativeWindow() NN_NOEXCEPT
        {
            return m_NativeWindowHolder.GetNativeWindow();
        }

        void ReleaseNativeWindow() NN_NOEXCEPT
        {
            m_NativeWindowHolder.Reset();
        }

        native::NativeWindowHolder m_NativeWindowHolder;
    private:
        LayerId m_Id;
        DisplayHolder* m_pDisplayHolder;
    };

    typedef nn::util::IntrusiveList<
        LayerHolder,
        nn::util::IntrusiveListBaseNodeTraits<LayerHolder>
    > LayerHolderList;

}}
