﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_CropRegion.h>

#include <algorithm>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn{ namespace vi{

    CropRegion CropRegion::Intersect(const CropRegion& a, const CropRegion& b) NN_NOEXCEPT
    {
        int32_t left   = std::max(a.x, b.x);
        int32_t top    = std::max(a.y, b.y);
        int32_t right  = std::min(a.x + a.width, b.x + b.width);
        int32_t bottom = std::min(a.y + a.height, b.y + b.height);
        CropRegion crop = {};
        if(right - left > 0 && bottom - top > 0)
        {
            crop.x = left;
            crop.y = top;
            crop.width = right - left;
            crop.height = bottom - top;
        }
        return crop;
    }

}}
