﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>
#include <nn/sf/sf_ShimLibraryUtility.h>

#define NN_VI_REQUIRES_INITIALIZED() NN_SDK_REQUIRES(GetService() != nullptr, "nn::vi is not initialized");
#define NN_VI_REQUIRES_INITIALIZED_SYSTEM() \
    NN_SDK_REQUIRES(GetSystemService() != nullptr, "nn::vi is not initialized as system");
#define NN_VI_REQUIRES_INITIALIZED_MANAGER() \
    NN_SDK_REQUIRES(GetManagerService() != nullptr, "nn::vi is not initialized as manager")

namespace nn{ namespace vi{

    nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService> GetService() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService> GetBlockingService() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService> GetSystemService() NN_NOEXCEPT;
    nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService> GetManagerService() NN_NOEXCEPT;

    nn::Result CreateBlockingService() NN_NOEXCEPT;

    static const size_t ObjectCountMax = 10;
    nn::sf::SimpleAllInOneHipcClientManager<ObjectCountMax>& GetClientManager() NN_NOEXCEPT;
}}
