﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/manager/vi_ManagerSharedBuffer.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#define NN_VI_MNGR_CALLM(pService, Invoke)   \
    NN_ABORT_UNLESS_RESULT_SUCCESS(pService->GetManagerDisplayService()-> Invoke)

namespace nn{ namespace vi{ namespace manager{

    ManagerSharedBuffer::ManagerSharedBuffer() NN_NOEXCEPT
        : m_pService()
        , m_Handle()
    {
    }

    bool ManagerSharedBuffer::IsInitialized() const NN_NOEXCEPT
    {
        return m_pService != nullptr;
    }

    nn::vi::fbshare::SharedBufferHandle ManagerSharedBuffer::GetHandle() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_Handle;
    }

    void ManagerSharedBuffer::Initialize(
        DisplayManagerService* pService,
        const nn::vi::fbshare::SharedMemoryPoolLayout& layout
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());

        nn::vi::fbshare::SharedBufferHandle h = {};
        NN_VI_MNGR_CALLM(pService, CreateSharedBufferStaticStorage(&h, nn::vi::fbshare::SharedBufferStaticStorageDefaultKey, layout));

        m_pService = pService;
        m_Handle = h;
    }

    void ManagerSharedBuffer::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());

        NN_VI_MNGR_CALLM(m_pService, DestroySharedBuffer(m_Handle));

        m_pService = nullptr;
        m_Handle = {};
    }

    void ManagerSharedBuffer::RegisterImporter(nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        NN_VI_MNGR_CALLM(m_pService, RegisterSharedBufferImporterAruid(m_Handle, importerAruid));
    }

    void ManagerSharedBuffer::UnregisterImporter(nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        NN_VI_MNGR_CALLM(m_pService, UnregisterSharedBufferImporterAruid(m_Handle, importerAruid));
    }

}}}
