﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/sf/sf_HipcServer.h>

#include <nn/usb/usb_Limits.h>
#include <nn/usb/usb_PmTypes.h>

namespace nn {
namespace usb {
namespace pm {

class Pm;

class PmServiceManager
    : public nn::sf::HipcSimpleAllInOneServerManager<PmLimitMaxSessionCount, 1>
{
public:
    Result Initialize(Pm *pPm) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

private:
    Pm                                    *m_pPm;

    // SF thread
    nn::os::ThreadType                     m_ServiceThread;
    NN_OS_ALIGNAS_THREAD_STACK char        m_ServiceThreadStack[1024 * 16];

private:
    virtual Result OnNeedsToAccept(int portIndex, PortForAllInOne *pPort) NN_NOEXCEPT;
    static  void   ServiceThreadEntry(void *arg) NN_NOEXCEPT
    {
        PmServiceManager *pThis = reinterpret_cast<PmServiceManager*>(arg);

        pThis->LoopAuto();
    }
};

} // end of namespace pm
} // end of namespace usb
} // end of namespace nn
