﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.usb
{
    [CppRefPath(@"<nn/usb/usb_PmTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct UsbDataRole{}

    [CppRefPath(@"<nn/usb/usb_DiagTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct DiagData{}
}

namespace nn.usb.pm
{
    [CppRefPath(@"<nn/usb/pm/sfdl/usb_IPmService.sfdl.h>")]
    public interface IPmService : IServiceObject
    {
        [MethodId(0)]
        Result GetPowerEvent(Out<NativeHandle> eventHandle);

        [MethodId(1)]
        Result GetPowerState(OutBuffer state);

        [MethodId(2)]
        Result GetDataEvent(Out<NativeHandle> eventHandle);

        [MethodId(3)]
        Result GetDataRole(Out<UsbDataRole> role);

        [MethodId(4)]
        Result SetDiagData(DiagData data, uint32_t value);

        [MethodId(5)]
        Result GetDiagData(DiagData data, Out<uint32_t> pOutValue);
    }
}
