﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/sf/sf_Types.h>
#include "detail/usb_IPdManager.h"
#include "detail/usb_IPdCradleManager.h"

namespace nn { namespace usb { namespace pd {

// 実装オブジェクトに HIPC を介してアクセスする場合に、PdManager への参照を取得する関数
// 別途 StartUpdServer が先によばれて、サーバーが立ち上がっている必要がある。
nn::sf::SharedPointer<detail::IPdManager> CreatePdManagerByHipc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IPdCradleManager> CreatePdCradleManagerByHipc() NN_NOEXCEPT;

// 実装オブジェクトに DFC でアクセスする場合に PdManager への参照を取得する関数
nn::sf::SharedPointer<detail::IPdManager> CreatePdManagerByDfc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IPdCradleManager> CreatePdCradleManagerByDfc() NN_NOEXCEPT;

}}}
