﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "server/usb_PdCradleManagerImpl.h"
#include "detail/usb_IPdCradleManager.h"    // for IPdCradleManager

#include "usb_PdCreateManager.h"

namespace nn { namespace usb { namespace pd {


nn::sf::SharedPointer<detail::IPdCradleManager> CreatePdCradleManagerByDfc() NN_NOEXCEPT
{
    // CreateSharedEmplaced で Impl 側を紐付けた SharedPointer を返す。
    // Manager は 1つだけ存在する状態にしたいので、StaticOneAllocationPolicy でアロケートする。
    // TODO : impl の StaticOneAllocationPolicy を使ってしまっているが、
    //        正式なものが出来たらそちらに変更する。
    typedef nn::sf::ObjectFactory<nn::sf::impl::StaticOneAllocationPolicy>  Factory;
    return Factory::CreateSharedEmplaced<detail::IPdCradleManager, server::PdCradleManagerImpl>();

}


}}}
