﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Internal utilities
 *
 * @details
 *
 *
 */

#pragma once

namespace nn { namespace usb { namespace hs {


class Util
{
public:
    static Result GetMemoryBusAddress(void *address, uint32_t size, uint64_t *pRetBusAddr);
    static uint32_t RoundupDmaBufferSize(uint32_t nominalSize);
    static const char* GetClassCodeDescription(uint8_t classCode);
    static Result GetEpIntervalInUs(UsbDeviceSpeed devSpeed,  UsbEndpointDescriptor *pEpDesc, uint32_t *pRetInterval);
    static bool EvaluateDeviceId(DeviceFilter *pFilter, UsbInterfaceDescriptor *pIfDesc,
                                 UsbDeviceDescriptor *pDevDesc);
    static UsbEndpointMask GetEndpointMask(UsbEndpointDirection epDir, EndpointNumber epNumber);
    static UsbEndpointMask GetEndpointMask(HostEndpoint *pHep);
    static UsbEndpointMask GetEndpointFromMask(UsbEndpointMask mask, UsbEndpointDirection *pEpDir, EndpointNumber *pEndpointNumber);
    static uint32_t GetControlTransferMaxPacketSize(UsbDeviceSpeed devSpeed);
    static const char* GetEndpointDescription(UsbEndpointDescriptor *epd);
    static const char* GetEndpointDescription(UsbEndpointType epType, UsbEndpointDirection epDirection);
    static const char* GetSpeedDescription(UsbDeviceSpeed speed);
    static void PrintDescriptors(UsbConfigDescriptor *pCfgDesc, UsbDeviceDescriptor *pDevDesc, UsbDeviceSpeed speed,
                                 DeviceInterface *ifArray,
                                 HostEndpoint *epIn,
                                 HostEndpoint *epOut);
    static void PrintInterfaceQuery(InterfaceQueryOutput *pQuery);
    static void PrintInterfaceProfile(InterfaceProfile *pInterfaceProfile);
    static bool IsValidEndpointDescriptor(UsbEndpointDescriptor *pEpDesc, UsbDeviceSpeed speed);
    static uint32_t FindLastSetBit(uint32_t mask32);
};


} // end of namespace hs
} // end of namespace usb
} // end of namespace nn

