﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Data types with scope internal to host stack
 *        implemenation
 *
 * @details
 *
 *
 */

#pragma once

namespace nn { namespace usb { namespace hs {

class HostControllerDriverEndpoint;

typedef uint32_t UsbEndpointMask;

enum StartupMode
{
    StartupMode_Default = 0,
    StartupMode_Reset,
    StartupMode_SelectiveEnumeration,
    StartupMode_WarmRecovery,
};

enum UsbBusToken
{
    UsbBusToken_Invalid = 0,
    UsbBusToken_Setup,
    UsbBusToken_Out,
    UsbBusToken_In,
};

enum XferStatus
{
    XferStatus_Invalid,   // Invalid xfer
    XferStatus_Failed,    // Xfer submission is failed
    XferStatus_Pending,   // Xfer is submitted
    XferStatus_Finished,  // Xfer is finished (w/ or w/o error)
};

struct HostEndpoint
{
    EndpointNumber                    epNumber;
    UsbEndpointType                   epType;
    UsbEndpointDirection              epDir;
    UsbEndpointDescriptor            *pDescriptor;
    UsbEndpointCompanionDescriptor   *pCompanionDescriptor;

    uint32_t                          maxUrbCount;      // max URBs can be queued

    uint64_t                          ifMask;
    bool                              toggle;
    bool                              isShortTransferError;
    HubPortNumber                     splitTxnPortNumber;
    uint8_t                           splitTxnAddress;
    HostControllerDriverEndpoint*     pHcEp;
    void*                             adminContext;
};

} // end of namespace hs
} // end of namespace usb
} // end of namespace nn

