﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief USB Host Stack Platform Controller Abstraction
 *
 * @details
 *
 *
 */

#pragma once

namespace nn { namespace usb { namespace hs {

class PlatformController : public detail::UsbController
{
public:
    explicit PlatformController(uint32_t capability) NN_NOEXCEPT
        : detail::UsbController(capability | UsbCapability_Host)
        ,m_pHs(nullptr)
        ,m_pPlatform(nullptr)
    {
        memset(m_RootHubPortPowerRefCounts, 0, sizeof(m_RootHubPortPowerRefCounts));
    }

    ~PlatformController() NN_NOEXCEPT
    {
        // do nothing
    }

    // Base class UsbController methods
    virtual Result Initialize(detail::UsbComplex* pComplex,
                              detail::UsbController::Config* pConfig) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Finalize() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Enable() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Disable() NN_NOEXCEPT NN_OVERRIDE;

    // hs::PlatformController methods
    virtual uintptr_t GetBaseAddress() NN_NOEXCEPT = 0;
    virtual detail::RegisterBlock* GetBaseRegister() NN_NOEXCEPT = 0;
    virtual Result SetTestMode(uint32_t port, TestMode mode, int32_t offset, uint32_t *pOutStrength) NN_NOEXCEPT = 0;
    Result Bind(Hs* pHs);
    Result Unbind();
    Hs* LockStack();
    void UnlockStack();

    // Root port power control
    virtual int SetRootHubPortPower(HubPortNumber hubPortNumber, bool isPowerOn);

protected:
    Hs*                   m_pHs;
    detail::UsbPlatform*  m_pPlatform;
    int                   m_RootHubPortPowerRefCounts[HsLimitMaxHubPortsCount];
};

} // end of namespace hs
} // end of namespace usb
} // end of namespace nn

