﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "usb_HsPrivateIncludes.h"

namespace nn { namespace usb { namespace hs {

void DeferredRequestBase::AsynchronousRequest(ActionHandler     action,
                                              CompletionHandler complete)
{
    m_AvailabilitySemaphore.Acquire();

    // Save the handlers
    m_Action   = action;
    m_Complete = complete;
    m_Result   = ResultSuccess();

    // Submit the request
    m_RequestQueue.Send(reinterpret_cast<uintptr_t>(this));
}

void DeferredRequestBase::SynchronousRequest(ActionHandler     action,
                                             CompletionHandler complete)
{
    AsynchronousRequest(action, complete);

    Flush();
}

void DeferredRequestBase::Dispatch()
{
    Result result = m_Action();

    if (!ResultDeferred::Includes(result))
    {
        CompleteRequest(result);
    }
}

void DeferredRequestBase::CompleteRequest()
{
    if (m_Complete)
    {
        m_Complete();
        m_Complete = nullptr;
    }

    m_AvailabilitySemaphore.Release();
}

void DeferredRequestBase::CompleteRequest(Result status)
{
    m_Result = status;

    CompleteRequest();
}

void DeferredRequestBase::CompleteRequest(Result status, uint32_t transferredSize)
{
    m_TransferredSize = transferredSize;

    CompleteRequest(status);
}

void DeferredRequestBase::Flush()
{
    m_AvailabilitySemaphore.Acquire();
    m_AvailabilitySemaphore.Release();
}

int32_t DeferredRequestBase::GetCommand()
{
    return m_Command;
}

char DeferredRequestBase::GetCategory()
{
    return m_Category;
}

Result DeferredRequestBase::GetActionResult()
{
    return m_Result;
}

uint32_t DeferredRequestBase::GetXferredSize()
{
    return m_TransferredSize;
}


} // end of namespace hs
} // end of namespace usb
} // end of namespace nn
