﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "usb_DsCommon.h"
#include "../detail/usb_Platform.h"

namespace nn {
namespace usb {
namespace ds {

struct DsServiceManagerOption
{
    static const int SubDomainCountMax = DsLimitMaxSubdomainCount;
    static const int ObjectInSubDomainCountMax = DsLimitMaxObjectPerSubdomain;
};

class DsServiceManager
    : public nn::sf::HipcSimpleAllInOneServerManager<DsLimitMaxSessionCount, 1, DsServiceManagerOption>
{
public:
    Result Initialize(detail::UsbPlatform *pPlatform) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

private:
    detail::UsbPlatform               *m_pPlatform;

    // Thread Pool
    nn::os::ThreadType                 m_ThreadPool[DsLimitSfThreadCount];
    NN_OS_ALIGNAS_THREAD_STACK uint8_t m_ThreadStack[DsLimitSfThreadCount][DsLimitSfThreadStackSize];

private:
    virtual Result OnNeedsToAccept(int portIndex, PortForAllInOne *pPort) NN_NOEXCEPT;
    static  void   ThreadEntryStatic(void *arg) NN_NOEXCEPT;
};

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn

