﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_DsChargingDevice.h
 * @brief   USB Device Stack Charging Device
 */

#include "usb_DsCommon.h"
#include "usb_DsDescriptor.h"

namespace nn {
namespace usb {
namespace ds {

struct UsbHidDescriptorParam
{

    uint8_t bDescriptorType;
    uint16_t wDescriptorLength;

} NN_USB_PACKED_STRUCT_ATTRIBUTE;

struct UsbHidDescriptor
{

    uint8_t bLength;
    uint8_t bDescriptorType;
    uint16_t bcdHid;
    uint8_t bCountryCode;
    uint8_t bNumDescriptors;

    UsbHidDescriptorParam descriptorParam[1];

} NN_USB_PACKED_STRUCT_ATTRIBUTE;

class DsProtocol;

class DsChargingDevice
{
public:

    explicit DsChargingDevice() NN_NOEXCEPT;
    ~DsChargingDevice() NN_NOEXCEPT {};

    Result Initialize(DsProtocol *pDsProtocol) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

private:

    DsProtocol *m_pDsProtocol;

    nn::os::ThreadType                  m_Thread;
    static const int32_t                m_ThreadStackSize = 1024 * 16;
    NN_OS_ALIGNAS_THREAD_STACK uint8_t  m_ThreadStack[m_ThreadStackSize];
    NN_OS_ALIGNAS_THREAD_STACK uint8_t  m_TxBuffer[4096];

    nn::os::MultiWaitType               m_MultiWait;
    nn::os::MultiWaitHolderType         m_FinalizeHolder;
    nn::os::MultiWaitHolderType         m_TimerHolder;
    nn::os::EventType                   m_FinalizeEvent;
    nn::os::TimerEventType              m_TimerEvent;

    static void TxThread(void *arg) NN_NOEXCEPT
    {
        DsChargingDevice *pThis = reinterpret_cast<DsChargingDevice *>(arg);

        pThis->TxLoop();
    }

    void   TxLoop() NN_NOEXCEPT;
};

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
