﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.usb
{
    [CppRefPath(@"<nn/usb/usb_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct ComplexId{}

    [CppRefPath(@"<nn/usb/usb_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct UsbDeviceSpeed{}

    [CppRefPath(@"<nn/usb/usb_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct UsbState{}

    [CppRefPath(@"<nn/usb/usb_DeviceTypes.h>")]
    [ExternalStruct(132, 4)]
    public struct UrbReport{}
}

namespace nn.usb.ds
{
    [CppRefPath(@"<nn/usb/ds/sfdl/usb_IDsService.sfdl.h>")]
    public interface IDsService : IServiceObject
    {
        [MethodId(0)]
        Result BindComplex(ComplexId complexId);

        [MethodId(1)]
        Result BindClientProcess(NativeHandle processHandle);

        [MethodId(2)]
        Result RegisterInterface(Out<IDsInterface> pInterface, uint8_t bInterfaceNumber);

        [MethodId(3)]
        Result GetStateChangeEvent(Out<NativeHandle> eventHandle);

        [MethodId(4)]
        Result GetState(Out<UsbState> state);

        [MethodId(5)]
        Result ClearDeviceData();

        [MethodId(6)]
        Result AddUsbStringDescriptor(Out<uint8_t> pIndex, InBuffer pUsbStringDescriptor);

        [MethodId(7)]
        Result DeleteUsbStringDescriptor(uint8_t index);

        [MethodId(8)]
        Result SetUsbDeviceDescriptor(InBuffer pUsbDeviceDescriptor, UsbDeviceSpeed usbDeviceSpeed);

        [MethodId(9)]
        Result SetBinaryObjectStore(InBuffer pBinaryObjectStore);

        [MethodId(10)]
        Result Enable();

        [MethodId(11)]
        Result Disable();
    }

    [CppRefPath(@"<nn/usb/ds/sfdl/usb_IDsInterface.sfdl.h>")]
    public interface IDsInterface : IServiceObject
    {
        [MethodId(0)]
        Result RegisterEndpoint(uint8_t          endpointAddress,
                                Out<IDsEndpoint> pEndpoint);
        [MethodId(1)]
        Result GetSetupEvent(Out<NativeHandle> eventHandle);

        [MethodId(2)]
        Result GetSetupPacket(OutBuffer setup);

        [MethodId(3)]
        Result Enable();

        [MethodId(4)]
        Result Disable();

        [MethodId(5)]
        Result CtrlInAsync(Out<uint32_t>     pUrbId,
                           uint64_t          address,
                           uint32_t          bytes);

        [MethodId(6)]
        Result CtrlOutAsync(Out<uint32_t>     pUrbId,
                            uint64_t          address,
                            uint32_t          bytes);

        [MethodId(7)]
        Result GetCtrlInCompletionEvent(Out<NativeHandle> eventHandle);

        [MethodId(8)]
        Result GetCtrlInUrbReport(Out<UrbReport> report);

        [MethodId(9)]
        Result GetCtrlOutCompletionEvent(Out<NativeHandle> eventHandle);

        [MethodId(10)]
        Result GetCtrlOutUrbReport(Out<UrbReport> report);

        [MethodId(11)]
        Result CtrlStall();

        [MethodId(12)]
        Result AppendConfigurationData(uint8_t bInterfaceNumber, UsbDeviceSpeed usbDeviceSpeed, InBuffer pData);
    }

    [CppRefPath(@"<nn/usb/ds/sfdl/usb_IDsEndpoint.sfdl.h>")]
    public interface IDsEndpoint : IServiceObject
    {
        [MethodId(0)]
        Result PostBufferAsync(Out<uint32_t>     pUrbId,
                               uint64_t          address,
                               uint32_t          bytes);

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result GetCompletionEvent(Out<NativeHandle> eventHandle);

        [MethodId(3)]
        Result GetUrbReport(Out<UrbReport> report);

        [MethodId(4)]
        Result Stall();

        [MethodId(5)]
        Result SetZlt(bool zlt);
    }
}
