﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "usb_Controller.h"
#include "usb_Complex.h"

namespace nn {
namespace usb {
namespace detail {

Result UsbController::Initialize(UsbComplex *pComplex, Config* pConfig) NN_NOEXCEPT
{
    Result result = ResultSuccess();

    m_pComplex   = pComplex;
    m_Config     = *pConfig;
    m_IsEnabled  = false;

    Register.Initialize(m_Config.reg.basePhysicalAddress, m_Config.reg.size);

    return result;
}

Result UsbController::Finalize() NN_NOEXCEPT
{
    Result result = ResultSuccess();

    m_pComplex  = nullptr;
    m_IsEnabled = false;
    Register.Finalize();
    memset(&m_Config, 0, sizeof(m_Config));

    return result;
}

Result UsbController::Enable() NN_NOEXCEPT
{
    m_IsEnabled = true;

    return ResultSuccess();
}

Result UsbController::Disable() NN_NOEXCEPT
{
    m_IsEnabled = false;

    return ResultSuccess();
}

bool UsbController::IsEnabled() NN_NOEXCEPT
{
    return m_IsEnabled;
}

uint32_t UsbController::GetCapability() NN_NOEXCEPT
{
    return m_Capability;
}

int UsbController::GetName(char *pOutName, uint32_t maxSize) NN_NOEXCEPT
{
    int ret;
    if(m_Config.pName)
    {
        ret = nn::util::Strlcpy(pOutName, m_Config.pName, maxSize);
    }
    else
    {
        ret = nn::util::Strlcpy(pOutName, "INVALID", maxSize);
    }
    return ret;
}

detail::SmmuMapManager& UsbController::DoSmmu() NN_NOEXCEPT
{
    NN_USB_ABORT_IF_NULL(m_Config.pSmmu);
    return *m_Config.pSmmu;
}

} // end of namespace detail
} // end of namespace usb
} // end of namespace nn
