﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;


namespace nn.uart
{
    // 実操作を担当する UART のセッションオブジェクト。
    // セッションの取得は Manager で行う。
    [CppRefPath("<nn/uart/uart_IPortSession.sfdl.h>")]
    interface IPortSession : IServiceObject
    {
        // PortConfigType はユーザーからは構造体で渡されるが、トランスファーメモリを使うため、SF レイヤではばらして渡している
        // InitializePortConfig() と SetPortConfigFlowControlMode() は Shim レイヤで Driver と同じ処理を行う
        // ただの数値として、渡して構造体にセットするだけとかはやってもいいかも。
        [MethodId(0)]
        Result OpenPort(Out<bool> isSuccess, int32_t name, int32_t baudRate, int32_t flowControlMode,
                                 NativeHandle sendHandle, uint64_t sendLength,
                                 NativeHandle receiveHandle, uint64_t receiveLength,
                                 bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts);

        [MethodId(1)]
        Result OpenPortForDev(Out<bool> isSuccess, int32_t portIndex, int32_t baudRate, int32_t flowControlMode,
                                  NativeHandle sendHandle, uint64_t sendLength,
                                  NativeHandle receiveHandle, uint64_t receiveLength,
                                  bool isInvertTx, bool isInvertRx, bool isInvertRts, bool isInvertCts);


        [MethodId(2)]
        Result GetWritableLength(Out<int64_t> size);

        [MethodId(3)]
        Result Send(Out<int64_t> doneBytes, [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.InBuffer inData);

        [MethodId(4)]
        Result GetReadableLength(Out<int64_t> size);

        [MethodId(5)]
        Result Receive(Out<int64_t> doneBytes, [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.OutBuffer outData);

        [MethodId(6)]
        Result BindPortEvent(Out<bool> result, Out<NativeHandle> handle, int32_t eventType, int64_t threshold);

        [MethodId(7)]
        Result UnbindPortEvent(Out<bool> result, int32_t eventType);
    }

    // Port ごとのセッションを返すマネージャークラス
    [CppRefPath("<nn/uart/uart_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result HasPort(Out<bool> hasPort, int32_t name);

        [MethodId(1)]
        Result HasPortForDev(Out<bool> hasPort, int32_t portIndex);

        [MethodId(2)]
        Result IsSupportedBaudRate(Out<bool> isSupported, int32_t name, int32_t baudRate);

        [MethodId(3)]
        Result IsSupportedBaudRateForDev(Out<bool> isSupported, int32_t portIndex, int32_t baudRate);

        [MethodId(4)]
        Result IsSupportedFlowControlMode(Out<bool> isSupported, int32_t name, int32_t flowControlMode);

        [MethodId(5)]
        Result IsSupportedFlowControlModeForDev(Out<bool> isSupported, int32_t portIndex, int32_t flowControlMode);

        [MethodId(6)]
        Result CreatePortSession(Out<IPortSession> outSession);

        [MethodId(7)]
        Result IsSupportedPortEvent(Out<bool> isSupported, int32_t name, int32_t portEvent);

        [MethodId(8)]
        Result IsSupportedPortEventForDev(Out<bool> isSupported, int32_t portIndex, int32_t portEvent);
    }
}
