﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


namespace nn {
namespace uart {
namespace driver {
namespace detail {

enum class CommandName
{
    Send,
    Receive
};

/**
 * @brief   Send コマンド用パラメタ&クラス
 */
struct CommandParamSend
{
    struct CommandParamSendIn
    {
        const char*     data;
        size_t          dataBytes;
    } in;
    struct CommandParamSendOut
    {
        size_t          doneBytes;
    } out;
};

class CommandSend
{
public:
    CommandSend() NN_NOEXCEPT {}

    void Setup(const char* data, int dataBytes) NN_NOEXCEPT
    {
        // in 以外のパラメータの初期化は Execute 処理側の責任
        m_Param.in.data = data;
        m_Param.in.dataBytes = dataBytes;
    };
    CommandParamSend& GetParam() NN_NOEXCEPT
    {
        return m_Param;
    };

private:
    CommandParamSend    m_Param;
    // const CommandName   m_Name; // 今のところ不要
};

/**
 * @brief   Receive コマンド用パラメタ&クラス
 */
struct CommandParamReceive
{
    struct CommandParamReceiveIn
    {
        char*           data;
        size_t          dataBytes;
    } in;
    struct CommandParamReceiveOut
    {
        nn::Result      result;
        size_t          doneBytes;
    } out;
};

class CommandReceive
{
public:
    CommandReceive() NN_NOEXCEPT {}

    void Setup(char* data, int dataBytes) NN_NOEXCEPT
    {
        // in 以外のパラメータの初期化は Execute 処理側の責任
        m_Param.in.data = data;
        m_Param.in.dataBytes = dataBytes;
    };
    CommandParamReceive& GetParam() NN_NOEXCEPT
    {
        return m_Param;
    };

private:
    CommandParamReceive m_Param;
    // const CommandName   m_Name; // 今のところ不要
};


} // detail
} // driver
} // uart
} // nn
