﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName

#include <nn/ts/impl/ts.h>
#include <nn/ts/server/ts_HipcServiceName.h>
#include <nn/ts/server/ts_IMeasurementServer.autogen.h>
#include <nn/ts/server/ts_MeasurementServer.h>

namespace nn {
namespace ts {
namespace server {


::nn::Result MeasurementServer::GetTemperatureRange(nn::sf::Out<LimitTemperature> outLimitTemperature, std::uint8_t location) NN_NOEXCEPT
{
    *outLimitTemperature = impl::GetTemperatureRange(static_cast<Location>(location));
    NN_RESULT_SUCCESS;
}


::nn::Result MeasurementServer::GetTemperature(nn::sf::Out<int> outTemperature, std::uint8_t location) NN_NOEXCEPT
{
    int outTemp = 0;
    NN_RESULT_DO(impl::GetTemperature(&outTemp, static_cast<Location>(location)));
    *outTemperature = outTemp;
    NN_RESULT_SUCCESS;
}

::nn::Result MeasurementServer::GetTemperatureMilliC(nn::sf::Out<int> outTemperatureMilliC, std::uint8_t location) NN_NOEXCEPT
{
    int outTempMilliC = 0;
    NN_RESULT_DO(impl::GetTemperatureMilliC(&outTempMilliC, static_cast<Location>(location)));
    *outTemperatureMilliC = outTempMilliC;
    NN_RESULT_SUCCESS;
}

::nn::Result MeasurementServer::SetMeasurementMode(std::uint8_t location, std::uint8_t measurementMode) NN_NOEXCEPT
{
    impl::SetMeasurementMode(static_cast<Location>(location), static_cast<MeasurementMode>(measurementMode));
    NN_RESULT_SUCCESS;
}

} // server
} // ts
} // nn
