﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>

#include <nn/ts/impl/ts.h>
#include <nnd/tmp451/tmp451.h>

namespace nn {
namespace ts {
namespace impl {
namespace detail {

// 計測レンジ:
static const nnd::tmp451::MeasurementRange RangeSetting = nnd::tmp451::MeasurementRange::Standard;

// TODO: Tmp451 にレンジを数値で取得する関数を nnd::tmp451 に追加する
static const LimitTemperature RangeTemperature = {0, 127};

// 計測レート：2^n [計測/秒]
static const int Rate = 5;

// バスタイムアウト
static const bool BusTimeout = false;

// リモートフィルター
static const nnd::tmp451::DigitalFilter RemoteFilter = nnd::tmp451::DigitalFilter::FilterOff;

// リモートオフセット [℃]
//static const nnd::tmp451::Temperature RemoteOffset = { 0, 0 };

// リモートη-factor
static const int8_t RemoteEta = 0x00;

// THERM ヒステリシス [℃]
static const uint8_t Hysterisis = 0x00;

// ALERT コンセクティブ
static const nnd::tmp451::AlertConsecutive Consecutive = nnd::tmp451::AlertConsecutive::Consecutive4;

// Pin1(THERM) 限度値 [℃]
static const nnd::tmp451::Temperature Pin1LocalHighLimit = {85,0};

// Pin2 限度値 [℃]
static const nnd::tmp451::Temperature Pin2LocalHighLimit = {85,0};
static const nnd::tmp451::Temperature Pin2RemoteHighLimit = {108,0};
static const nnd::tmp451::Temperature Pin2LocalLowLimit = {0,0};
static const nnd::tmp451::Temperature Pin2RemoteLowLimit = {0,0};

// Pin2検知モード
static const nnd::tmp451::DetectionMode Pin2mode = nnd::tmp451::DetectionMode::Alert;



} // detail
} // impl
} // ts
} // nn
