﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "ts_FirmwareDebugSettingsAccessor.h"

namespace nn { namespace ts { namespace impl { namespace detail {

class SettingsHolder
{
    NN_DISALLOW_COPY(SettingsHolder);
    NN_DISALLOW_MOVE(SettingsHolder);

public:
    SettingsHolder() NN_NOEXCEPT;

    //! settings から設定を取得します。
    void LoadSettings() NN_NOEXCEPT;

    //! 外部センサの温度のオフセットを取得します。
    int GetRemoteTemperatureOffsetMilliC() NN_NOEXCEPT;

    //! 外部センサの温度上限を取得します。
    int GetRemoteShutdownTemperatureHighLimitMilliC() NN_NOEXCEPT;

private:

    //! 外部センサの温度のオフセット。
    int m_RemoteTemperatureOffsetMilliC;

    //! 外部センサの温度上限。
    int m_RemoteShutdownTemperatureHighLimitMilliC;

    //! Firmware Debug Settings にアクセスするためのオブジェクト。
    FirmwareDebugSettingsAccessor m_FirmwareDebugSettingsAccessor;
};

}}}} // namespace nn::ts::impl::detail
