﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/TargetConfigs/build_Base.h>

#include <nn/nn_Common.h>

#include <nn/ts/ts_Types.h>

#include <nnd/tmp451/tmp451.h>

#include "ts_ISensorController.h"

namespace nn {
namespace ts {
namespace impl {
namespace detail {


//// Location_SocCpu
//class SocCpuController final : public ISensorController
//{
//    NN_DISALLOW_COPY(SocCpuController);
//    NN_DISALLOW_MOVE(SocCpuController);
//
//public:
//    SocCpuController() NN_NOEXCEPT {};
//    virtual ~SocCpuController() NN_NOEXCEPT {};
//
//    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;
//    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual int GetTemperature() NN_NOEXCEPT NN_OVERRIDE;
//};
//
//
//// Location_SocGpu
//class SocGpuController final : public ISensorController
//{
//    NN_DISALLOW_COPY(SocGpuController);
//    NN_DISALLOW_MOVE(SocGpuController);
//
//public:
//    SocGpuController() NN_NOEXCEPT {};
//    virtual ~SocGpuController() NN_NOEXCEPT {};
//
//    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;
//    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual int GetTemperature() NN_NOEXCEPT NN_OVERRIDE;
//};
//
//
//// Location_SocPll
//class SocPllController final : public ISensorController
//{
//    NN_DISALLOW_COPY(SocPllController);
//    NN_DISALLOW_MOVE(SocPllController);
//
//public:
//    SocPllController() NN_NOEXCEPT {};
//    virtual ~SocPllController() NN_NOEXCEPT {};
//
//    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;
//    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual int GetTemperature() NN_NOEXCEPT NN_OVERRIDE;
//};
//
//
//// Location_SocMem
//class SocMemController final : public ISensorController
//{
//    NN_DISALLOW_COPY(SocMemController);
//    NN_DISALLOW_MOVE(SocMemController);
//
//public:
//    SocMemController() NN_NOEXCEPT {};
//    virtual ~SocMemController() NN_NOEXCEPT {};
//
//    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;
//    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual int GetTemperature() NN_NOEXCEPT NN_OVERRIDE;
//};


// Location_ThermalSensorInternal
class ThermalSensorInternalController final : public ISensorController
{
    NN_DISALLOW_COPY(ThermalSensorInternalController);
    NN_DISALLOW_MOVE(ThermalSensorInternalController);

public:
    ThermalSensorInternalController() NN_NOEXCEPT {};
    virtual ~ThermalSensorInternalController() NN_NOEXCEPT {};

    virtual nn::Result Initialize() NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result GetTemperature(int* pOutTemperature) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetTemperatureMilliC(int* pOutTemperatureMilliC) NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetMeasurementMode(MeasurementMode measurementMode) NN_NOEXCEPT NN_OVERRIDE;
};


// Location_ThermalSensorExternal
class ThermalSensorExternalController final : public ISensorController
{
    NN_DISALLOW_COPY(ThermalSensorExternalController);
    NN_DISALLOW_MOVE(ThermalSensorExternalController);

public:
    ThermalSensorExternalController() NN_NOEXCEPT {};
    virtual ~ThermalSensorExternalController() NN_NOEXCEPT {};

    virtual nn::Result Initialize() NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::Result GetTemperature(int* pOutTemperature) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetTemperatureMilliC(int* pOutTemperatureMilliC) NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetMeasurementMode(MeasurementMode measurementMode) NN_NOEXCEPT NN_OVERRIDE;
};


//// Location_Battery
//class BatteryController final : public ISensorController
//{
//    NN_DISALLOW_COPY(BatteryController);
//    NN_DISALLOW_MOVE(BatteryController);
//
//public:
//    BatteryController() NN_NOEXCEPT {};
//    virtual ~BatteryController() NN_NOEXCEPT {};
//
//    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;
//    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT NN_OVERRIDE;
//
//    virtual int GetTemperature() NN_NOEXCEPT NN_OVERRIDE;
//};



} // detail
} // impl
} // ts
} // nn
