﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * @file
 * @brief   ライブラリAPIの実態
 */

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Result.h>

#include <nn/ts/impl/ts.h>

#include "ts_ISensorController.h"
#include "ts_Devices.h"

namespace nn {
namespace ts {
namespace impl {
namespace detail {

nn::Result InitializeResourceManager() NN_NOEXCEPT;
nn::Result FinalizeResourceManager() NN_NOEXCEPT;
ISensorController& GetSensorController(Location location) NN_NOEXCEPT;
bool IsLocationValid(Location location) NN_NOEXCEPT;

} // detail
} // impl
} // ts
} // nn
