﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace tmipc {

// !!! NOTICE !!! NEVER EVER CHANGE ANY OF THE SERVICE ID'S IN THIS ENUMERATION

enum : unsigned
{
    ServiceId_DebugService              = 0xddde6636,
    ServiceId_ControllerService         = 0x0955e925,
    ServiceId_LogService                = 0x373e20c5,
    ServiceId_LaunchService             = 0x3ac1167b,
    ServiceId_EnvService                = 0xc191dac9,
    ServiceId_HostIOService             = 0x5fae4d7e,
    ServiceId_HostDirectoryIOService    = 0xb04489f2,
    ServiceId_HTCSService               = 0xb644d830,
    ServiceId_ChannelService            = 0x41d1ae3f,
    ServiceId_BenchmarkReportService    = 0x378d2db4,
    ServiceId_BenchmarkService          = 0xba2c1174,
    ServiceId_PerformanceMonitorService = 0xa148f3a6,   // Service::HashString( "PerformanceMonitor::Service" );
    ServiceId_PowerManagementService    = 0xcc11bcfd,
    ServiceId_SettingsService           = 0x8a4f6b62,
    ServiceId_ThreadFrozenService       = 0x5898b956,
    ServiceId_CoreDumpService           = 0x50bf64e6,
    ServiceId_DiagnosticsService        = 0xce69fb16,
    ServiceId_TargetIOService           = 0x8e69bdd7,
    ServiceId_GenericService            = 0x58cf2177,   // Service::HashString( "GenericService::Service" );
    ServiceId_NodeTICS_BeaconQuery      = 0x30eb2f3a,   // Service::HashString( "NodeTICS-BeaconQuery" );
    ServiceId_NodeTICS_TMSInfo          = 0xf8da3cd6,   // Service::HashString( "NodeTICS-TMSInfo" );
    ServiceId_NodeUSB_BeaconQuery       = 0x3a8ddd94,   // Service::HashString( "NodeUSB-BeaconQuery" );
    ServiceId_NodeUSB_TMSInfo           = 0x4d4a6c24,   // Service::HashString( "NodeUSB-TMSInfo" );
    ServiceId_NodeUSB_ConnectHandshake  = 0xcd5ed1b8,   // Service::HashString( "NodeUSB-ConnectHandshake" );

    // SigloNTD-10074: Unify the behavior of SDEV and EDEV when user selects Disconnect.
    // This "Packet message" is not guarateed to be received when Disconnected
    // from in Target Manager - it only works when a "clean disconnect" happens
    // from Target Manager.  The result of receiving this message is to cancel
    // all pending tasks.
    ServiceId_NodeUSB_Disconnect        = 0xf97fe6b9,   // Service::HashString( "NodeUSB-Disconnect" );
    //---------------------------------------------- << insert new service identifers above this line and below any other service identifier that is already defined
    ServiceId_BackwardsCompatibilitySentinel,
};

} // namespace tmipc
