﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================

template<class T>
inline List<T>::List()
{
    m_pHead     = NULL;
    m_pTail     = NULL;
}

//==============================================================================

template<class T>
inline void List<T>::Clear()
{
    m_pHead     = NULL;
    m_pTail     = NULL;
}

//==============================================================================

template <class T>
inline bool List<T>::IsEmpty() const
{
    return( m_pHead == NULL );
}

//==============================================================================

template <class T>
inline s32 List<T>::GetSize() const
{
    s32 Size = 0;
    T* pNode = m_pHead;
    while( pNode )
    {
        Size++;
        pNode = (T*)pNode->m_pNext;
    }
    return Size;
}

//==============================================================================

template<class T>
inline T* List<T>::GetHead()
{
    return m_pHead;
}

//==============================================================================

template<class T>
inline const T* List<T>::GetTail() const
{
    return m_pTail;
}

//==============================================================================

template<class T>
inline const T* List<T>::GetHead() const
{
    return m_pHead;
}

//==============================================================================

template<class T>
inline T* List<T>::GetTail()
{
    return m_pTail;
}

//==============================================================================

template <class T>
inline void List<T>::AddHead( T* pNode )
{
    if( m_pHead != NULL )
    {
        m_pHead->m_pPrev = pNode;
    }

    pNode->m_pNext = m_pHead;
    pNode->m_pPrev = NULL;
    m_pHead = pNode;

    if( m_pTail == NULL )
    {
        m_pTail = pNode;
    }
}

//==============================================================================

template <class T>
inline void List<T>::AddTail( T* pNode )
{
    if( m_pTail != NULL )
    {
        m_pTail->m_pNext = pNode;
    }

    pNode->m_pNext = NULL;
    pNode->m_pPrev = m_pTail;
    m_pTail = pNode;

    if( m_pHead == NULL )
    {
        m_pHead = pNode;
    }
}

//==============================================================================

template <class T>
inline void List<T>::InsertBefore( T* pRefNode, T* pNode )
{
    ASSERT( pRefNode );

    if( pRefNode->m_pPrev )
    {
        pRefNode->m_pPrev->m_pNext = pNode;
    }
    else
    {
        m_pHead = pNode;
    }
    pNode->m_pPrev = pRefNode->m_pPrev;
    pNode->m_pNext = pRefNode;
    pRefNode->m_pPrev = pNode;
}

//==============================================================================

template <class T>
inline T* List<T>::RemoveHead()
{
    if( IsEmpty() )
    {
        return NULL;
    }

    T* pNode = m_pHead;
    if( pNode->m_pNext )
    {
        pNode->m_pNext->m_pPrev = NULL;
    }
    m_pHead = pNode->m_pNext;

    if( m_pHead == NULL )
    {
        m_pTail = NULL;
    }

    return pNode;
}

//==============================================================================

template <class T>
inline T* List<T>::RemoveTail()
{
    if( IsEmpty() )
    {
        return NULL;
    }

    T* pNode = m_pTail;
    if( pNode->m_pPrev )
    {
        pNode->m_pPrev->m_pNext = NULL;
    }
    m_pTail = pNode->m_pPrev;

    if( m_pTail == NULL )
    {
        m_pHead = NULL;
    }

    return pNode;
}

//==============================================================================

template <class T>
inline void List<T>::Remove( T* pNode )
{
    if( pNode->m_pPrev )
    {
        pNode->m_pPrev->m_pNext = pNode->m_pNext;
    }
    else
    {
        m_pHead = pNode->m_pNext;
    }

    if( pNode->m_pNext )
    {
        pNode->m_pNext->m_pPrev = pNode->m_pPrev;
    }
    else
    {
        m_pTail = pNode->m_pPrev;
    }
}

//==============================================================================
