﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
namespace tmipc {
//==============================================================================

template<class T>
class List
{
    T*  m_pHead;                                                // Pointer to the head node in the list.
    T*  m_pTail;                                                // Pointer to the tail node in the list.

public:
                    List            ();                         // List constructor.

    inline void     Clear           ();                         // Clear the list.
    inline bool     IsEmpty         () const;                   // Check if the list is empty.
    inline s32      GetSize         () const;                   // Get the size of the list.

    inline T*       GetHead         ();                         // Get the node at the head of the list, but do not remove it.
    inline T*       GetTail         ();                         // Get the node at the tail of the list, but do not remove it.
    inline const T* GetHead         () const;                   // Get the node at the head of the list, but do not remove it.
    inline const T* GetTail         () const;                   // Get the node at the tail of the list, but do not remove it.
    inline void     AddHead         ( T* pNode );               // Add a node to the head of the list.
    inline void     AddTail         ( T* pNode );               // Add a node to the tail of the list.
    inline void     InsertBefore    ( T* pRefNode, T* pNode );  // Insert a new node into this list before the reference node.
    inline T*       RemoveHead      ();                         // Remove the head node from the list.
    inline T*       RemoveTail      ();                         // Remove the tail node from the list.
    inline void     Remove          ( T* pNode );               // Remove the given node form the list.
};

//==============================================================================
//  Include the implementation header
//==============================================================================

#include "tmipc_list_inline.h"

//==============================================================================
} // namespace tmipc
//==============================================================================
