﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifdef WIN32
#define TMIPC_TARGET_WIN
#else
#define TMIPC_TARGET_HORIZON
#endif

#include <cstdio>
#include "tmipc_task_type.h"

#define TMIPC_DEFINE(_a_) (_a_)

#ifdef TMIPC_TARGET_WIN
#ifndef NTDDI_WIN7SP1
#define NTDDI_WIN7SP1 TMIPC_DEFINE(0x06010100)
#endif
#include <SDKDDKVer.h>
#include <WinSock2.h>
#include <tchar.h>
#include <cassert>
#ifndef ASSERT
#define ASSERT assert
#endif
#ifdef VERIFY
#undef VERIFY
#endif
#define VERIFY( _a_ ) (void)(_a_)
#include <ws2tcpip.h>
#endif

#ifdef TMIPC_TARGET_HORIZON
#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#define ASSERT NN_SDK_ASSERT
#define VERIFY( _a_ ) (void)(_a_)

#if defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || defined(NN_BUILD_CONFIG_HARDWARE_NX) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
#define NN_DETAIL_TMA_NX_RELATED_HARDWARE
#endif
#endif

#include <stdint.h>

typedef int8_t          s8;
typedef uint8_t         u8;
typedef int16_t         s16;
typedef uint16_t        u16;
typedef int32_t         s32;
typedef uint32_t        u32;
typedef int64_t         s64;
typedef uint64_t        u64;

#define TMIPC_INFINITE TMIPC_DEFINE(-1)

//==============================================================================
namespace tmipc {
//==============================================================================

enum
{
    TMIPC_SERVER_NODE_ID        = 0,
    TMIPC_CLIENT_NODE_ID        = 1,
};

//==============================================================================


enum eConfig
{
    TMIPC_VERSION               = 4,            // Protocol version number.
    TMIPC_NUM_SEND_PACKETS      = 8,            // How many send packets to allocate.
    TMIPC_NUM_RECV_PACKETS      = 8,            // How many recv packets to allocate.
    TMIPC_CONNECT_TIMEOUT_MS    = 2000,         // Connect timeout in ms.
    TMIPC_WORK_QUEUE_DEPTH      = 128,          // Depth of the work queue.
    TMIPC_NUM_PRIORITIES        = 16,           // Number of priorities for Tasks.
    TMIPC_TMSINFO_PACKET_SIZE   = 4096,         // The maximum number of bytes for the TMS Info Packet.
};

// ProtocolVersion represents the backwards compatibility level of the target.
// It is encoded as the 'BCID' value in beacon response.
// The target sends this identifier in the beacon response packet whenever it
// connects to TargetManager and TargetManager uses it to determine what task
// level the target supports.  Any TaskType (shown above) which has a value less
// than ProtocolVersion is allowed, and anything greater or equal will fail.
// Whenever a new task types is added, TaskType_BackwardsCompatibilitySentinel
// will increment. An older target with a previous version of the SDK will not
// have any knowledge of the new tasks and will not send or receive any TaskType
// which out of range of the enumeration.

// There are various backwards compatibility sentinels that, if changed, will
// create static asserts throughout the code to help guide you through the process
// of adding new features.  Be sure to correctly implement any requirements
// before repairing the sentinel asserts.

enum {ProtocolVersion = TaskType_BackwardsCompatibilitySentinel - 1};

// Make sure this is in sync with TargetManager's [equivalent]
// ENABLE_BENCHMARK_TESTING #define.
//
// 0 = disable benchmark testing.
// 1 = enable benchmark testing.
#if !defined(TMIPC_TARGET_HORIZON) || defined(NN_DETAIL_TMA_NX_RELATED_HARDWARE)
#define ENABLE_BENCHMARK_TESTING TMIPC_DEFINE(1)
#if !defined( TMIPC_TARGET_WIN )
// 0 = disable peformance monitor service.
// 1 = enable performance monitor service.
#define ENABLE_PERFORMANCE_MONITOR_SERVICE TMIPC_DEFINE(0)
#else
// 0 = disable performance monitor service.
// 1 = enable performance monitor service.
#define ENABLE_PERFORMANCE_MONITOR_SERVICE TMIPC_DEFINE(0)
#endif
#endif

//TODO: Remove this hack.  __PRETTY_FUNCTION__ is not recognized in "Sim Instance" builds.
#if 1
#define TMA_POWER_TEST_PRINT( ... )
#else
#define TMA_POWER_TEST_PRINT( ... ) NN_SDK_LOG( __VA_ARGS__ )
#define _BestFunctionName_ __PRETTY_FUNCTION__
//#define _BestFunctionName_ __FUNCTION__
#endif

//==============================================================================
} // namespace tmipc
//==============================================================================
