﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmagent.h"

//==============================================================================
namespace tma {
//==============================================================================

typedef void* THREAD_FUNCTION ( void* pArgs );

class Thread
{
    nn::os::ThreadType  m_Thread;
    void*               m_pStack;
    bool                m_Initialized;
    void*               m_pUnalignedStackBegin;
    u64                 m_AllocatedSize;
public:
explicit                Thread      ( );
                       ~Thread      ( );
            void        Start       ( THREAD_FUNCTION*  pfnThread,
                                      void*             pArg,
                                      size_t            StackSize,
                                      int               Priority,
                                      const char*       pName );
            void        CancelSync  ();
            void        Join        ();
            void        Destroy     ();
#if defined(NN_TMA_SIM_INSTANCE)
            bool        IsRunning   () const;
            bool        HasExited   () const;
#endif
static      void        Sleep       ( s32               MS );
};

//==============================================================================
} // namespace tma
//==============================================================================
