﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmagent.h"
#include <nn/socket.h>

//==============================================================================
namespace tma {
//==============================================================================

class Socket
{
            int         m_Socket;

public:
static      void        InitSockets     ();
static      void        KillSockets     ();

explicit                Socket          ();
explicit                Socket          ( int                   Socket );
                       ~Socket          ();

            s32         CreateUDP       ();
            s32         CreateTCP       ();

            bool        IsValid         ();

            s32         Listen          ( s32                   Backlog );
            s32         Bind            ( nn::socket::SockAddr* pAddr,
                                          nn::socket::SockLenT  AddrLen );

            Socket      Accept          ( nn::socket::SockAddr* pAddr,
                                          nn::socket::SockLenT* pAddrLen );

            s32         RecvFrom        ( void*                 pBuffer,
                                          s32                   nBytes,
                                          nn::socket::SockAddr* pAddr,
                                          nn::socket::SockLenT* pAddrLen );

            s32         SendTo          ( void*                 pBuffer,
                                          s32                   nBytes,
                                          nn::socket::SockAddr* pAddr,
                                          nn::socket::SockLenT  AddrLen );

            s32         EnableBroadcast ();
            s32         SetTCPNoDelay   ();

            s32         Recv            ( void*                 pBuffer,
                                          s32                   nBytes );

            s32         Send            ( void*                 pBuffer,
                                          s32                   nBytes );

            s32         Shutdown        ();
            s32         Close           ();
};

//==============================================================================
} // namespace tma
//==============================================================================
