﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\tmagent.h"
#include "tma_Mutex.h"

//==============================================================================
namespace tma {
//==============================================================================

Mutex::Mutex()
{
}

//==============================================================================

void Mutex::Create()
{
    nn::os::InitializeMutex( &m_Mutex, true, 0 );
}

//==============================================================================

void Mutex::Destroy()
{
    nn::os::FinalizeMutex( &m_Mutex );
}

//==============================================================================

void Mutex::Lock()
{
    nn::os::LockMutex( &m_Mutex );
}

//==============================================================================

void Mutex::Unlock()
{
    nn::os::UnlockMutex( &m_Mutex );
}

//==============================================================================
} // namespace tma
//==============================================================================
