﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\DejaInsight.h"
#include <cstdlib>
#include <nn/lmem/lmem_ExpHeap.h>
#include "..\tmagent.h"

// Only use this memmgr as a default heap for TMA with the device.
// Win32 will use either a custom allocator passed in or the system defaults.
#ifndef WIN32
//==============================================================================
#ifdef new
#undef new
#endif

#ifdef delete
#undef
#endif

#ifdef malloc
#undef malloc
#endif

#ifdef realloc
#undef realloc
#endif

#ifdef free
#undef free
#endif


//==============================================================================
//
//  Redirect new and delete to our custom allocators/deallocators.
//
//
//==============================================================================

#ifndef CAFE

void* operator new ( size_t Size )
{
    void* pResult = tma::s_Allocate( Size );
    DEJA_LOG_NEW( pResult, Size );
    return( pResult );
}

#endif

//------------------------------------------------------------------------------

void* operator new ( size_t Size, const char* pFileName, int Line )
{
    void* pResult = tma::s_Allocate( Size );
    DEJA_LOG_NEW( pResult, Size, pFileName, Line );
    return( pResult );
}

//------------------------------------------------------------------------------

void* operator new ( size_t Size, const wchar_t* pFileName, int Line )
{
    void* pResult = tma::s_Allocate( Size );
    DEJA_LOG_NEW( pResult, Size, pFileName, Line );
    return( pResult );
}

//==============================================================================

#ifndef CAFE

void* operator new [] ( size_t Size )
{
    void* pResult = tma::s_Allocate( Size );
    DEJA_LOG_NEW_ARRAY( pResult, Size );
    return ( pResult );
}

#endif

//------------------------------------------------------------------------------

void* operator new [] ( size_t Size, const char* pFileName, int Line )
{
    void* pResult = tma::s_Allocate( Size );
    DEJA_LOG_NEW_ARRAY( pResult, Size, pFileName, Line );
    return( pResult );
}

//------------------------------------------------------------------------------

void* operator new [] ( size_t Size, const wchar_t* pFileName, int Line )
{
    void* pResult = tma::s_Allocate( Size );
    DEJA_LOG_NEW_ARRAY( pResult, Size, pFileName, Line );
    return( pResult );
}

//==============================================================================

#ifndef CAFE

void operator delete ( void* pMemory ) NN_NOEXCEPT
{
    if( pMemory )
    {
        // Recommendation:  Only log when the pointer is non-NULL.
        DEJA_LOG_DELETE( pMemory );
    }

    // These incorrect sizes are acceptable, since this code only exists for
    // device builds, where we do not support custom allocator/deallocators.
    tma::s_Deallocate( pMemory, 0 );
}

#endif

//------------------------------------------------------------------------------

void operator delete ( void* pMemory, const char* pFileName, int Line )
{
    if( pMemory )
    {
        // Recommendation:  Only log when the pointer is non-NULL.
        DEJA_LOG_DELETE( pMemory, pFileName, Line );
    }

    // These incorrect sizes are acceptable, since this code only exists for
    // device builds, where we do not support custom allocator/deallocators.
    tma::s_Deallocate( pMemory, 0 );
}

//------------------------------------------------------------------------------

void operator delete ( void* pMemory, const wchar_t* pFileName, int Line )
{
    if( pMemory )
    {
        // Recommendation:  Only log when the pointer is non-NULL.
        DEJA_LOG_DELETE( pMemory, pFileName, Line );
    }

    // These incorrect sizes are acceptable, since this code only exists for
    // device builds, where we do not support custom allocator/deallocators.
    tma::s_Deallocate( pMemory, 0 );
}

//==============================================================================

#ifndef CAFE

void operator delete [] ( void* pMemory ) NN_NOEXCEPT
{
    if( pMemory )
    {
        // Recommendation:  Only log when the pointer is non-NULL.
        DEJA_LOG_DELETE_ARRAY( pMemory );
    }

    // These incorrect sizes are acceptable, since this code only exists for
    // device builds, where we do not support custom allocator/deallocators.
    tma::s_Deallocate( pMemory, 0 );
}

#endif

//------------------------------------------------------------------------------

void operator delete [] ( void* pMemory, const char* pFileName, int Line )
{
    if( pMemory )
    {
        // Recommendation:  Only log when the pointer is non-NULL.
        DEJA_LOG_DELETE_ARRAY( pMemory, pFileName, Line );
    }

    // These incorrect sizes are acceptable, since this code only exists for
    // device builds, where we do not support custom allocator/deallocators.
    tma::s_Deallocate( pMemory, 0 );
}

//------------------------------------------------------------------------------

void operator delete [] ( void* pMemory, const wchar_t* pFileName, int Line )
{
    if( pMemory )
    {
        // Recommendation:  Only log when the pointer is non-NULL.
        DEJA_LOG_DELETE_ARRAY( pMemory, pFileName, Line );
    }

    // These incorrect sizes are acceptable, since this code only exists for
    // device builds, where we do not support custom allocator/deallocators.
    tma::s_Deallocate( pMemory, 0 );
}

#endif
//==============================================================================
