﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//==============================================================================
//  INCLUDES
//==============================================================================

#include "..\tmagent.h"
#include "tio_Task.h"
#include "tio_Service.h"
#include "..\tmipc\tmipc_packet.h"

#if DEBUG
#define TIO_LOG(...) NN_SDK_LOG( __VA_ARGS__ );
#else
#define TIO_LOG(...)
#endif

//==============================================================================
namespace tma { namespace target_io {
//==============================================================================

Service::Service()
{
    DEJA_TRACE( "tma::target_io::Service::Service", "tma::target_io::Service" );
    m_ServiceId = HashString( "TIOService" );
    TIO_LOG( "[tma][tio] - Service::Service\n" );
}

//==============================================================================

Service::~Service()
{
    DEJA_TRACE( "tma::target_io::Service::Service", "~tma::target_io::Service" );
    TIO_LOG( "[tma][tio] - Service::~Service\n" );
}

//==============================================================================

void Service::Init()
{
    DEJA_TRACE( "tma::target_io::Service::Init", "Init" );
    TIO_LOG( "[tma][tio] - Service::Init\n" );
    Create();
    //===========================================================
    // Can't do this here:  When we're flashing,
    // the fs system doesn't have the card driver loaded.
    //===========================================================
    //nn::tma::target_io::Initialize();
}

//==============================================================================

void Service::Kill()
{
    DEJA_TRACE( "tma::target_io::Service::Kill", "Kill" );
    TIO_LOG( "[tma][tio] - Service::Kill\n" );
    Destroy();
}

//==============================================================================

tmipc::Task* Service::OnNewTask( tmipc::Packet* pPacket )
{
    TIO_LOG( "[tma][tio] - Service::OnNewTask:  %d\n", pPacket->GetTaskType() );
    tmipc::Task* pRet = NULL;
    void* pMem = NULL;

    switch( pPacket->GetTaskType() )
    {
        case tmipc::TaskType_TIOFileRead:
            pMem = s_Allocate( sizeof(TIOTaskFileRead) );
            pRet = new (pMem) TIOTaskFileRead();
            break;
        case tmipc::TaskType_TIOFileWrite:
            pMem = s_Allocate( sizeof(TIOTaskFileWrite) );
            pRet = new (pMem) TIOTaskFileWrite();
            break;

        case tmipc::TaskType_TIOFileSetAttributes:
            pMem = s_Allocate( sizeof(TIOTaskFileSetAttributes) );
            pRet = new (pMem) TIOTaskFileSetAttributes();
            break;
        case tmipc::TaskType_TIOFileSetTime:
            pMem = s_Allocate( sizeof(TIOTaskFileSetTime) );
            pRet = new (pMem) TIOTaskFileSetTime();
            break;

        case tmipc::TaskType_TIOFileSetSize:
            pMem = s_Allocate( sizeof(TIOTaskFileSetSize) );
            pRet = new (pMem) TIOTaskFileSetSize();
            break;
        case tmipc::TaskType_TIOFileDelete:
            pMem = s_Allocate( sizeof(TIOTaskFileDelete) );
            pRet = new (pMem) TIOTaskFileDelete();
            break;
        case tmipc::TaskType_TIOFileMove:
            pMem = s_Allocate( sizeof(TIOTaskFileMove) );
            pRet = new (pMem) TIOTaskFileMove();
            break;
        case tmipc::TaskType_TIOFileGetInformation:
            pMem = s_Allocate( sizeof(TIOTaskFileGetInformation) );
            pRet = new (pMem) TIOTaskFileGetInformation();
            break;
        case tmipc::TaskType_TIODirectoryCreate:
            pMem = s_Allocate( sizeof(TIOTaskDirectoryCreate) );
            pRet = new (pMem) TIOTaskDirectoryCreate();
            break;
        case tmipc::TaskType_TIODirectoryDelete:
            pMem = s_Allocate( sizeof(TIOTaskDirectoryDelete) );
            pRet = new (pMem) TIOTaskDirectoryDelete();
            break;
        case tmipc::TaskType_TIODirectoryMove:
            pMem = s_Allocate( sizeof(TIOTaskDirectoryMove) );
            pRet = new (pMem) TIOTaskDirectoryMove();
            break;
        case tmipc::TaskType_TIODirectoryGetInformation:
            pMem = s_Allocate( sizeof(TIOTaskDirectoryGetInformation) );
            pRet = new (pMem) TIOTaskDirectoryGetInformation();
            break;
        case tmipc::TaskType_TIOSearchFetch:
            pMem = s_Allocate( sizeof(TIOTaskSearchFetch) );
            pRet = new (pMem) TIOTaskSearchFetch();
            break;
        case tmipc::TaskType_TIOGetFreeSpace:
            pMem = s_Allocate( sizeof(TIOTaskGetFreeSpace) );
            pRet = new (pMem) TIOTaskGetFreeSpace();
            break;
        case tmipc::TaskType_TIOGetVolumeInformation:
            pMem = s_Allocate( sizeof(TIOTaskGetVolumeInformation) );
            pRet = new (pMem) TIOTaskGetVolumeInformation();
            break;

        default:
            DEJA_ERROR( "tma::target_io::Service::OnNewTask", "Unrecognized task type 0x%08x", pPacket->GetTaskType() );
            ASSERT( 0 );
            break;
    }

    if( pRet )
    {
        pRet->SetServicesManager( m_pServicesManager );
        pRet->SetServiceId( m_ServiceId );
        pRet->SetTaskId( pPacket->GetTaskId() );
        pRet->SetTaskType( (s16)pPacket->GetTaskType() );
        pRet->OnInitiate( pPacket );
    }

    return( pRet );
}

//==============================================================================
}} // namespace
//==============================================================================
