﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <map>
#include "thread_frozen_api.h"

//==============================================================================
namespace tma { namespace threadfrozen {
//==============================================================================

std::map<u64, bool> g_ThreadFrozen;

//==============================================================================

bool SetThreadFrozen( u64 ThreadId, bool Frozen )
{
    auto Iterator = g_ThreadFrozen.find( ThreadId );
    if( Iterator == g_ThreadFrozen.end() )
    {
        g_ThreadFrozen.insert( std::pair<u64, bool>( ThreadId, Frozen ) );
    }
    else
    {
        Iterator->second = Frozen;
    }

    bool Test;
    bool Success = GetThreadFrozen( ThreadId, Test );

    return Success && (Test == Frozen);
}

//==============================================================================

bool GetThreadFrozen( u64 ThreadId, bool& Frozen )
{
    bool Success = false;
    auto Iterator = g_ThreadFrozen.find( ThreadId );
    if( Iterator != g_ThreadFrozen.end() )
    {
        Frozen = Iterator->second;
        Success = true;
    }

    return Success;
}

//==============================================================================

nn::Bit32 GetNumFrozenThreads()
{
    s32 Count = 0;
    for( auto Iterator = g_ThreadFrozen.begin(); Iterator != g_ThreadFrozen.end(); Iterator++ )
    {
        if( Iterator->second )
        {
            Count++;
        }
    }

    return Count;
}

//==============================================================================

nn::Bit64* GetFrozenThreadIds( nn::Bit32& Size )
{
    Size = GetNumFrozenThreads();
    nn::Bit64* ThreadIds = (nn::Bit64*)s_Allocate( sizeof(nn::Bit64) * Size );

    s32 Index = 0;
    for( auto Iterator = g_ThreadFrozen.begin(); Iterator != g_ThreadFrozen.end(); Iterator++ )
    {
        if( Iterator->second )
        {
            ThreadIds[Index++] = Iterator->first;
        }
    }

    return ThreadIds;
}

//==============================================================================

void ClearThreadFrozen( u64 ThreadId )
{
    g_ThreadFrozen.erase( ThreadId );
}

//==============================================================================

void ClearAllThreadFrozen()
{
    g_ThreadFrozen.clear();
}

//==============================================================================
}}
//==============================================================================
