﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "settings_service.h"
#include "settings_task.h"
#include <nn/nn_SdkLog.h>

//==============================================================================
namespace tma { namespace settings {
//==============================================================================

Service::Service()
{
    m_ServiceId = HashString( "SettingsService" );
}

//==============================================================================

Service::~Service()
{
}

//==============================================================================

tmipc::Task* Service::OnNewTask( tmipc::Packet* pPacket )
{
    void* pMem = s_Allocate( sizeof(settings::Task) );
    settings::Task* pTask = new (pMem) settings::Task();
    pTask->SetServicesManager( m_pServicesManager );
    pTask->SetServiceId( m_ServiceId );
    pTask->SetTaskId( pPacket->GetTaskId() );
    pTask->OnInitiate( pPacket );
    pTask->SetNeedPackets( true );

    return pTask;
}

//==============================================================================

void Service::Init()
{
    Create();
}

//==============================================================================

void Service::Kill()
{
    Destroy();
}

//==============================================================================
}} // namespace
//==============================================================================
