﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/tma/sf/tma_IFileManager.h>
#include "hio_api.h"

namespace nn { namespace tma {

class FileAccessorImpl
{
public:
    explicit FileAccessorImpl(file_io::TMA_FILE_HANDLE handle) NN_NOEXCEPT;
    ~FileAccessorImpl() NN_NOEXCEPT;
    nn::Result ReadFileForFs0(nn::sf::Out<std::int32_t> pOut, std::int64_t offset, const nn::sf::OutBuffer& pBuffer) NN_NOEXCEPT;
    nn::Result ReadFile(nn::sf::Out<std::int64_t> pOut, std::int64_t offset, const nn::sf::OutBuffer& pBuffer, nn::fs::ReadOption option) NN_NOEXCEPT;
    nn::Result WriteFileForFs0(nn::sf::Out<std::int32_t> pOut, std::int64_t offset, const nn::sf::InBuffer& pBuffer, bool flush) NN_NOEXCEPT;
    nn::Result WriteFile(std::int64_t offset, const nn::sf::InBuffer& pBuffer, nn::fs::WriteOption option) NN_NOEXCEPT;
    nn::Result GetFileSize(nn::sf::Out<std::int64_t> pOut) NN_NOEXCEPT;
    nn::Result SetFileSize(std::int64_t size) NN_NOEXCEPT;
    nn::Result FlushFile() NN_NOEXCEPT;
    nn::Result SetPriorityForFile(std::int32_t priority) NN_NOEXCEPT;
    nn::Result GetPriorityForFile(nn::sf::Out<std::int32_t> pOut) NN_NOEXCEPT;
private:
    file_io::TMA_FILE_HANDLE m_Handle;
};

}}
