﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "dbg_Enums.h"
#include "dbg_Process.h"
#include "dbg_CommandArgs.h"
#include "../tma/tma_Mutex.h"

//==============================================================================
namespace tma { namespace dbg {
//==============================================================================

class Process;

#if !defined( NN_TMA_SIM_INSTANCE )

struct ssm_exception
{
    u64                     exceptionAddress;
    nn::svc::DebugException exceptionCode;
};

class StepMgr
{
protected:

        enum
        {
            MAX_DATA_SIZE       = 16
        };

        u64                     GetBranchTarget                     ( u64& CurNext, bool bSingleStep = false );
        void                    SingleStep                          ();

        Process*                m_pParent;
        per_thread_step_info    m_PTSI;

        u64                     m_SP;
        u64                     m_IP;
        u64                     m_AddrLo;
        u64                     m_AddrHi;
        u64                     m_ThreadId;

        u64                     m_DataAddr;
        u8                      m_OldData[ MAX_DATA_SIZE ];
        u8                      m_NewData[ MAX_DATA_SIZE ];

        bp_state                m_BPState;
        step_state              m_StepState;
        s32                     m_TempCount;
        s32                     m_MaxTempCount;
        bool                    m_bCallInst;

        nn::svc::Handle         m_Handle;

        tma::Mutex              m_SSMMutex;     // Mutex for SteppingStateMachine

        break_point             m_SavedBP;
        ssm_exception           m_PrevSSME;

        void                    GetLocalBP                          ( break_point& curBP, ssm_exception* pSSME = 0 );
        void                    SaveLocalBP                         ( bool bSingleStep = false );
        bool                    OutsideSteppingBounds               ();
        void                    ResumeExecution                     ();

public:
                                StepMgr                             ();

        void                    Init                                ( Process* Process );
        void                    Kill                                ();

        step_state              SetSteppingInfo                     ( StepDebugCommandArgs* pArgs );
        void                    SteppingStateMachine                ( u64 ThreadId, step_state InitialState, ssm_exception* pSSME = 0 );
};

#endif

//==============================================================================
}} // namespace
//==============================================================================
