﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// WARNING: THERE ARE TWO COPIES OF THIS FILE WHICH MUST STAY IN SYNC

#pragma once

#include "..\tmagent.h"

//==============================================================================

namespace tma { namespace dbg {

//==============================================================================
// Command packet.  Used internally by target agent to translate command values
// from target client into varied-parameter commands.
struct Command
{
    u64     m_ProcessId;
    u64     m_Parameter;
    u32     m_Command;
    s32     m_DataSize;
    void*   m_pData;

    Command( u32 Command, u64 ProcessId, u64 Parameter, s32 DataSize, void* pData )
    {
        m_Command   = Command;
        m_ProcessId = ProcessId;
        m_Parameter = Parameter;
        m_DataSize  = DataSize;
        m_pData     = pData;
    }
};

//==============================================================================
}} // namespace
//==============================================================================
