﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../tmipc/tmipc_defines.h"
#include "../tmipc/tmipc_packet.h"
#include "../tmipc/tmipc_service.h"
#include "../dbg\dbg_ProcessMgr.h"

//==============================================================================
namespace tma { namespace coredump {
//==============================================================================

class Service : public tmipc::Service
{
private:
    tma::dbg::ProcessMgr*   m_pProcessMgr;
    struct working_task*    m_pWorkingTasks;
    struct working_task*    m_pCompletedTasks;
    tma::Mutex              m_TaskListMutex;

virtual tmipc::Task*        OnNewTask       ( tmipc::Packet* pPacket );
    //==============================================================================
    // Waiting task maintenance functionality
    void                    StartedTask     ( tmipc::Task*  pTask );

public:
    Service     ();
    ~Service    ();

    void                    Init            ( tma::dbg::ProcessMgr* pProcessMgr );
    void                    Kill            ();
    void                    OnComplete      ( tmipc::Task* pTask );

    tma::dbg::ProcessMgr*   GetProcessManager() { return m_pProcessMgr;}

};

Service& GetService( void );

//==============================================================================
}}
//==============================================================================
