﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "benchmark_service.h"
#if ENABLE_BENCHMARK_TESTING
#include "benchmark_task.h"
//#include <nn/nn_SdkLog.h>

//==============================================================================
namespace tma { namespace benchmark {
//==============================================================================

BenchmarkService::BenchmarkService()
{
//NN_SDK_LOG( "[BenchmarkService::BenchmarkService( %p )]\n", this );
    m_ServiceId = HashString( "BenchmarkService" );
//NN_SDK_LOG( "[BenchmarkService::BenchmarkService( %p )] - HashString('BenchmarkService') == 0x%08x\n", this, GetId() );
}

//==============================================================================

BenchmarkService::~BenchmarkService()
{
//NN_SDK_LOG( "[BenchmarkService::~BenchmarkService( %p )]\n", this );
}

//==============================================================================

void BenchmarkService::Init()
{
//NN_SDK_LOG( "[BenchmarkService::Init( %p )]\n", this );
    Create();
}

//==============================================================================

void BenchmarkService::Kill()
{
//NN_SDK_LOG( "[BenchmarkService::Kill( %p )]\n", this );
    Destroy();
}

//==============================================================================

tmipc::Task* BenchmarkService::OnNewTask( tmipc::Packet* pPacket )
{
//NN_SDK_LOG( "[BenchmarkService::OnNewTask( 0x%p )] - Packet: 0x%p\n", this, pPacket );
    void* pMem = s_Allocate( sizeof( BenchmarkTask ) );
    BenchmarkTask* pTask = new (pMem) BenchmarkTask;
    pTask->SetServicesManager( m_pServicesManager );
    pTask->SetServiceId( m_ServiceId );
    pTask->SetTaskId( pPacket->GetTaskId() );
    pTask->OnInitiate( pPacket );
    return( pTask );
}

//==============================================================================
}} // namespace
//==============================================================================

#endif // ENABLE_BENCHMARK_TESTING
