﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../tmipc/tmipc_defines.h"
#if ENABLE_BENCHMARK_TESTING

#include "../tmipc/tmipc_packet.h"
#include "../tmipc/tmipc_task.h"

//==============================================================================
namespace tma { namespace benchmark {
//==============================================================================

class BenchmarkReportTask : public tmipc::Task
{
private:

    enum class Type : int32_t
    {
        Invalid = 0,
        Start,
        Stop,
        GetReport
    };

public:
    explicit    BenchmarkReportTask   ();
               ~BenchmarkReportTask   ();

virtual void    OnInitiate      ( tmipc::Packet*    pPacket );
virtual void    OnRecvPacket    ( tmipc::Packet*    pPacket );
virtual void    OnSendPacket    ( tmipc::Packet*    pPacket );
};

//==============================================================================
}}
//==============================================================================

#endif // ENABLE_BENCHMARK_TESTING
