﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
namespace tma {
//==============================================================================

    const char* GetTMAVersionNumber();

    // Generates a beacon response to send to TargetManager.
    bool GenerateBeaconResponse(    char* pBeaconResponse,
                                    const s32 BufferLength,
                                    const char* pConnectionType,
                                    bool IncludeMacAddress );

    // Get/set the Target's state.  This affects the Beacon Respons's "State" key/value.
    void SetHasWokenUp( bool bWokenUp );
    bool GetHasWokenUp();

    // This struct contains information that TMS sends during its initial "connection handshake".
    struct TMSInfo
    {
        s32  BCID;
        bool WasSleeping;
    };
    // Sets the TMSInfo to a default state.
    void SetToDefaultState(TMSInfo &tmsInfo);
    // Decode the given string into the TMSInfo.
    void DecodeTMSInfoString(TMSInfo &tmsInfo, const char* pString);

//==============================================================================
} // namespace tma
//==============================================================================
