﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/timesrv/timesrv_Api.h>
#include <nn/timesrv/detail/service/timesrv_ServiceProvider.h>
#include <nn/util/util_Optional.h>

namespace nn
{
namespace timesrv
{

namespace
{
    nn::util::optional<nn::timesrv::detail::service::ServiceProvider> g_pTimeProvider;
}

void Initialize() NN_NOEXCEPT
{
    NN_SDK_ASSERT(!g_pTimeProvider);
    g_pTimeProvider.emplace();
}

void LoopAutoTimeServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pTimeProvider);
    g_pTimeProvider->Start();
}

void RequestStopTimeServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pTimeProvider);
    g_pTimeProvider->RequestStopServer();
}

void Finalize() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pTimeProvider);
    g_pTimeProvider = nn::util::nullopt;
}


}
}
