﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/timesrv/detail/service/timesrv_SystemClockServer.h>

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/timesrv/detail/core/timesrv_StandardUserSystemClockCore.h>


namespace nn
{
namespace timesrv
{
namespace detail
{
namespace service
{

using ::nn::time::PosixTime;
using ::nn::time::SystemClockContext;
using ::nn::timesrv::detail::core::SystemClockCore;

SystemClockServer::SystemClockServer(SystemClockCore* pSystemClockCore, bool isAdministrator) NN_NOEXCEPT
    : m_pSystemClockCore(pSystemClockCore),
      m_IsAdministrator(isAdministrator)
{
}

SystemClockServer::~SystemClockServer() NN_NOEXCEPT
{
}

Result SystemClockServer::GetCurrentTime(nn::sf::Out<PosixTime> outPosixTime) NN_NOEXCEPT
{
    PosixTime posixTime;

    NN_RESULT_DO(m_pSystemClockCore->GetCurrentTime(&posixTime));

    outPosixTime.Set(posixTime);

    NN_RESULT_SUCCESS;
}

Result SystemClockServer::SetCurrentTime(const PosixTime& posixTime) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(m_IsAdministrator, nn::time::ResultNoCapability());

    NN_RESULT_DO(m_pSystemClockCore->SetCurrentTime(posixTime));

    NN_RESULT_SUCCESS;
}

Result SystemClockServer::GetSystemClockContext(nn::sf::Out<SystemClockContext> outSystemClockContext) NN_NOEXCEPT
{
    SystemClockContext systemClockContext;

    NN_RESULT_DO(m_pSystemClockCore->GetSystemClockContext(&systemClockContext));

    outSystemClockContext.Set(systemClockContext);

    NN_RESULT_SUCCESS;
}

Result SystemClockServer::SetSystemClockContext(const SystemClockContext& systemClockContext) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(m_IsAdministrator, nn::time::ResultNoCapability());

    NN_RESULT_DO(m_pSystemClockCore->SetSystemClockContext(systemClockContext));

    NN_RESULT_SUCCESS;
}

}
}
}
}
