﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/time_ApiForMenu.h>
#include <nn/time/time_ResultPrivate.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>
#include <nn/ntc/shim/ntc_Shim.h>

#include <nn/nn_SdkAssert.h>

namespace nn { namespace time {

extern nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService> g_pStaticService;
extern nn::sf::SharedPointer<nn::timesrv::detail::service::ITimeZoneService> g_pTimeZoneService;

void LoadLocationNameList(
    int* pOutCount,
    LocationName* pOutLocationNameList,
    int count,
    int offset
    ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutCount);
    NN_SDK_ASSERT_NOT_NULL(pOutLocationNameList);
    NN_SDK_ASSERT_GREATER_EQUAL(count, 1);
    NN_SDK_ASSERT_GREATER_EQUAL(offset, 0);

    NN_ABORT_UNLESS(g_pTimeZoneService != nullptr, "[TIME] The time library is not initialized.");

    nn::sf::OutArray<LocationName> outLocationNameList(pOutLocationNameList, static_cast<size_t>(count));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pTimeZoneService->LoadLocationNameList(
        pOutCount,
        outLocationNameList,
        offset));
}

int GetTotalLocationNameCount() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pTimeZoneService != nullptr, "[TIME] The time library is not initialized.");

    int32_t count;
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pTimeZoneService->GetTotalLocationNameCount(&count));
    return count;
}

void SetDeviceLocationName(const LocationName& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pTimeZoneService != nullptr, "[TIME] The time library is not initialized.");

    auto result = g_pTimeZoneService->SetDeviceLocationName(value);
    if(nn::time::ResultNotFound::Includes(result))
    {
        NN_ABORT("[TIME] nn::time::LocationName(%s) is invalid.", value._value);
    }
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void GetTimeZoneRuleVersion(TimeZoneRuleVersion* pOut) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pTimeZoneService != nullptr, "[TIME] The time library is not initialized.");
    NN_SDK_REQUIRES_NOT_NULL(pOut);

    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pTimeZoneService->GetTimeZoneRuleVersion(pOut));
}

int GetStandardUserSystemClockInitialYear() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pStaticService != nullptr, "[TIME] The time library is not initialized.");

    int32_t year;
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pStaticService->GetStandardUserSystemClockInitialYear(&year));

    return static_cast<int>(year);
}

}} // nn::time

