﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/detail/time_MonotonicSystemClock.h>

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/time/detail/time_SharedMemoryClient.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace time {

extern nn::util::optional<nn::time::detail::SharedMemoryClient> g_SharedMemoryClient;

namespace detail {

MonotonicSystemClock::MonotonicSystemClock() NN_NOEXCEPT
    : m_CachedContext {0, {0, nn::util::InvalidUuid}}
{
}

nn::time::SystemClockContext MonotonicSystemClock::GetSystemClockContext() const NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Lock);
    return m_CachedContext;
}

void MonotonicSystemClock::SetSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Lock);
    m_CachedContext = systemClockContext;
}

Result MonotonicSystemClock::GetCurrentTime(nn::time::PosixTime* pOutPosixTime) const NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_SharedMemoryClient, "[TIME] The time library is not initialized.");

    NN_UTIL_LOCK_GUARD(m_Lock);

    return g_SharedMemoryClient->CalculateSystemClockCurrentTime(pOutPosixTime, m_CachedContext);
}

bool MonotonicSystemClock::IsAdjusted() const NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_SharedMemoryClient, "[TIME] The time library is not initialized.");

    NN_UTIL_LOCK_GUARD(m_Lock);

    nn::time::PosixTime posix;
    auto result = g_SharedMemoryClient->CalculateSystemClockCurrentTime(&posix, m_CachedContext);
    return result.IsSuccess();
}

}}} // nn::time::detail
