﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_SystemEvent.h>
#include <nn/tcap/tcap_OperationModeTypes.h>

#include "tcap_ContinuousHighSkinTemperatureHandler.h"
#include "tcap_ThermalCoordinatorAdvancedPolicy.h"

namespace nn { namespace tcap { namespace server {

void ThermalCoordinatorAdvancedPolicy::Update(nn::TimeSpan elapsedTime) NN_NOEXCEPT
{
    if ( m_SettingsHolder.IsThermalBurnPreventionModeEnabled() )
    {
        // 低温やけど防止モードでは ContinuousHighSkinTemperatureHandler を使用してカウントを進める
        // 閾値を超えると ContinuousHighSkinTemperatureHandler がシグナルする
        m_ContinuousHighSkinTemperatureHandler.Update(elapsedTime);
    }
}

void ThermalCoordinatorAdvancedPolicy::ClearElapsedTime() NN_NOEXCEPT
{
    m_ContinuousHighSkinTemperatureHandler.ClearElapsedTime();
}

nn::os::SystemEventType* ThermalCoordinatorAdvancedPolicy::GetContinuousHighSkinTemperatureEvent() NN_NOEXCEPT
{
    return m_ContinuousHighSkinTemperatureHandler.GetSystemEvent();
}

void ThermalCoordinatorAdvancedPolicy::SetOperationMode(OperationMode operationMode) NN_NOEXCEPT
{
    m_ContinuousHighSkinTemperatureHandler.SetOperationMode(operationMode);
}

void ThermalCoordinatorAdvancedPolicy::LoadAndApplySettings() NN_NOEXCEPT
{
    m_SettingsHolder.LoadSettings();

    // 設定変更時はカウントはやり直し
    ClearElapsedTime();
}

ThermalCoordinatorAdvancedPolicy& GetThermalCoordinatorAdvancedPolicy() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(ThermalCoordinatorAdvancedPolicy, s_ThermalCoordinatorAdvancedPolicy);

    return s_ThermalCoordinatorAdvancedPolicy;
}

}}} // namespace nn::tcap::server
