﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/tcap/detail/tcap_Log.h>

namespace nn { namespace tcap { namespace server {

class FirmwareDebugSettingsAccessor
{
public:
    template <typename T>
    void ReadSetting(T* pOutValue, const char* pName, const char* pKey) NN_NOEXCEPT
    {
        auto size = nn::settings::fwdbg::GetSettingsItemValueSize(pName, pKey);
        if ( 0 == size )
        {
            NN_DETAIL_TCAP_WARN("Failed to read %s.%s (Value is not written)\n", pName, pKey);
            return;
        }
        else if ( sizeof(T) != size )
        {
            NN_DETAIL_TCAP_WARN("Failed to read %s.%s (data size does not match). expected=%d, actual=%d\n", pName, pKey, sizeof(T), size);
            return;
        }

        T value;
        if ( sizeof(T) != (nn::settings::fwdbg::GetSettingsItemValue(&value, sizeof(T), pName, pKey)) )
        {
            NN_DETAIL_TCAP_WARN("Failed to read %s.%s.\n", pName, pKey);
            return;
        }

        *pOutValue = value;
    }

    template <typename T>
    void ReadSetting(T* pOutValue, const char* pKey) NN_NOEXCEPT
    {
        ReadSetting(pOutValue, "tcap", pKey);
    }
};

}}} // namespace nn::tcap::server
