﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>

#include <nn/sf/impl/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_NativeHandle.h>

#include <nn/tc/impl/tc.h>
#include <nn/tc/tc_IManager.sfdl.h>
#include <nn/tc/tc_ManagerImpl.h>

namespace nn { namespace tc {

nn::Result ManagerImpl::SetOperatingMode(nn::tc::OperatingMode operatingMode) NN_NOEXCEPT
{
    NN_RESULT_DO(impl::SetOperatingMode(operatingMode));
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::GetThermalEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::tc::EventTarget target) NN_NOEXCEPT
{
    nn::os::SystemEventType* pEvent;
    NN_RESULT_DO(impl::GetEventPtr(&pEvent, target));
    nn::os::NativeHandle internalHandle = nn::os::GetReadableHandleOfSystemEvent(pEvent);
    *pOutHandle = nn::sf::NativeHandle(internalHandle, false);
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::IsActionAllowed(nn::sf::Out<bool> pOutPossible, nn::tc::Action action) NN_NOEXCEPT
{
    bool possible = false;
    NN_RESULT_DO(impl::IsActionAllowed(&possible, action));
    *pOutPossible = possible;
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::EnableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT
{
    NN_RESULT_DO(impl::EnableVirtualTemperature(location));
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::DisableVirtualTemperature(nn::tc::Location location) NN_NOEXCEPT
{
    NN_RESULT_DO(impl::DisableVirtualTemperature(location));
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::SetVirtualTemperature(nn::tc::Location location, int temperature) NN_NOEXCEPT
{
    NN_RESULT_DO(impl::SetVirtualTemperature(location, temperature));
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::EnableFanControl() NN_NOEXCEPT
{
    NN_RESULT_DO(impl::EnableFanControl());
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::DisableFanControl() NN_NOEXCEPT
{
    NN_RESULT_DO(impl::DisableFanControl());
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::IsFanControlEnabled(nn::sf::Out<bool> pOutEnabled) NN_NOEXCEPT
{
    bool enabled = true;
    NN_RESULT_DO(impl::IsFanControlEnabled(&enabled));
    *pOutEnabled = enabled;
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::GetSkinTemperatureMilliC(nn::sf::Out<TemperatureMilliC> pOutSkinTemperatureMilliC) NN_NOEXCEPT
{
    *pOutSkinTemperatureMilliC = impl::GetSkinTemperatureMilliC();
    NN_RESULT_SUCCESS;
}

}} // namespace nn::tc
