﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.tc
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/tc/tc_Types.h>")]
    public struct OperatingMode
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/tc/tc_Types.h>")]
    public struct Action
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/tc/tc_Types.h>")]
    public struct EventTarget
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/tc/tc_Types.h>")]
    public struct Location
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/tc/tc_Types.h>")]
    public struct TemperatureMilliC
    {
    }

    [CppRefPath("<nn/tc/tc_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result SetOperatingMode(OperatingMode operatingMode);

        [MethodId(1)]
        Result GetThermalEvent(Out<NativeHandle> pOutHandle, EventTarget target);

        [MethodId(2)]
        Result IsActionAllowed(Out<bool> pOutPossible, Action action);

        [MethodId(3)]
        Result EnableVirtualTemperature(Location location);

        [MethodId(4)]
        Result DisableVirtualTemperature(Location location);

        [MethodId(5)]
        Result SetVirtualTemperature(Location location, int_t temperature);

        [MethodId(6)]
        Result EnableFanControl();

        [MethodId(7)]
        Result DisableFanControl();

        [MethodId(8)]
        Result IsFanControlEnabled(Out<bool> pOutEnabled);

        [MethodId(9)]
        Result GetSkinTemperatureMilliC(Out<TemperatureMilliC> pOutSkinTemperatureMilliC);
   }
}
